/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.client;

import cloud.lemonslice.teastory.block.crops.TrellisBlock;
import cloud.lemonslice.teastory.block.crops.TrellisWithVineBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.blockentity.VineBlockEntity;
import xueluoanping.teastory.client.BakedQuadRetextured;

public class WarpBakeModel
implements IDynamicBakedModel {
    private final BakedModel bakedModel;
    private final Map<BlockState, List<BakedQuad>> stateListMap = new IdentityHashMap<BlockState, List<BakedQuad>>();
    private final TextureAtlasSprite cache;
    private final ItemOverrides itemOverrides;
    public static final ResourceLocation grape_leaves_on_beam = TeaStory.rl("block/grape_leaves_on_beam");
    public static final ResourceLocation grape_on_post_0 = TeaStory.rl("block/grape_on_post_0");
    public static final ResourceLocation grape_on_post_1 = TeaStory.rl("block/grape_on_post_1");
    public static final ResourceLocation grape_on_post_2 = TeaStory.rl("block/grape_on_post_2");
    public static final ResourceLocation grape_on_post_3 = TeaStory.rl("block/grape_on_post_3");
    public static final List<ResourceLocation> grapesRes = List.of(grape_on_post_0, grape_on_post_1, grape_on_post_2, grape_on_post_3);
    public static final List<BakedModel> grapes = new ArrayList<BakedModel>();

    public WarpBakeModel(BakedModel bakedModel, TextureAtlasSprite cache) {
        this.bakedModel = bakedModel;
        this.cache = cache;
        this.itemOverrides = new SelfItemOverrides(this);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        List<BakedQuad> bakedQuads = new ArrayList();
        if (state == null) {
            if (side != null) {
                return List.of();
            }
            bakedQuads = new ArrayList(this.bakedModel.getQuads(null, null, rand, extraData, renderType));
            for (Direction value : Direction.values()) {
                bakedQuads.addAll(this.bakedModel.getQuads(null, value, rand, extraData, renderType));
            }
        } else {
            bakedQuads = this.bakedModel.getQuads(state, side, rand, extraData, renderType);
        }
        if (!(bakedQuads instanceof ArrayList)) {
            bakedQuads = new ArrayList(bakedQuads);
        }
        for (int i = 0; i < bakedQuads.size(); ++i) {
            bakedQuads.set(i, new BakedQuadRetextured(bakedQuads.get(i), this.cache));
        }
        if (state != null && side == null && state.m_60734_() instanceof TrellisWithVineBlock) {
            if (((Boolean)state.m_61143_((Property)TrellisBlock.EAST)).booleanValue() || ((Boolean)state.m_61143_((Property)TrellisBlock.WEST)).booleanValue() || ((Boolean)state.m_61143_((Property)TrellisBlock.SOUTH)).booleanValue() || ((Boolean)state.m_61143_((Property)TrellisBlock.NORTH)).booleanValue()) {
                bakedQuads.addAll(Minecraft.m_91087_().m_91304_().getModel(grape_leaves_on_beam).m_213637_(null, null, rand));
            }
            if (((Boolean)state.m_61143_((Property)TrellisBlock.POST)).booleanValue()) {
                int age = 0;
                try {
                    age = (Integer)extraData.get(VineBlockEntity.AGE_PROPERTY);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bakedQuads.addAll(grapes.get(age).m_213637_(null, null, rand));
            }
        }
        return bakedQuads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return this.bakedModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.bakedModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.bakedModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.cache == null ? this.bakedModel.m_6160_() : this.cache;
    }

    public ItemOverrides m_7343_() {
        return this.itemOverrides;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VineBlockEntity) {
            VineBlockEntity vineBlockEntity = (VineBlockEntity)blockEntity;
            return modelData.derive().with(VineBlockEntity.AGE_PROPERTY, (Object)vineBlockEntity.getAge()).build();
        }
        return modelData;
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        this.bakedModel.m_7442_().m_269404_(transformType).m_111763_(applyLeftHandTransform, poseStack);
        return this;
    }

    public static class SelfItemOverrides
    extends ItemOverrides {
        private final WarpBakeModel warpBakeModel;

        public SelfItemOverrides(WarpBakeModel warpBakeModel1) {
            this.warpBakeModel = warpBakeModel1;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel pModel, ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
            return this.warpBakeModel;
        }
    }
}

